<?php

namespace App\Filament\Resources\EntryResource\Pages;

use App\Filament\Resources\EntryResource;
use App\Models\Entry;
use App\Models\Tag;
use Filament\Actions;
use Filament\Resources\Pages\EditRecord;
use Illuminate\Database\Eloquent\Model;

class EditEntry extends EditRecord
{
    protected static string $resource = EntryResource::class;

    protected function fillForm(): void
    {
        $data = $this->getRecord()->attributesToArray();
        $data['tags'] = $this->record->tags->pluck('title')->toArray();
        /** @internal Read the DocBlock above the following method. */
        $this->fillFormWithDataAndCallHooks($data);
    }

    protected function handleRecordUpdate(Model|Entry $record, array $data): Model
    {
        $record->syncTagsByTitle($data['tags']);
        $record->update($data);
        return $record;
    }

    protected function getHeaderActions(): array
    {
        return [
            Actions\DeleteAction::make(),
        ];
    }
}
